/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.observers;

import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.annotations.NonNull;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.util.AppendOnlyLinkedArrayList;
import nakadi.shadow.io.reactivex.internal.util.NotificationLite;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class SerializedObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    final boolean delayError;
    static final int QUEUE_LINK_SIZE = 4;
    Disposable s;
    boolean emitting;
    AppendOnlyLinkedArrayList<Object> queue;
    volatile boolean done;

    public SerializedObserver(@NonNull Observer<? super T> actual) {
        this(actual, false);
    }

    public SerializedObserver(@NonNull Observer<? super T> actual, boolean delayError) {
        this.actual = actual;
        this.delayError = delayError;
    }

    @Override
    public void onSubscribe(@NonNull Disposable s) {
        if (DisposableHelper.validate(this.s, s)) {
            this.s = s;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(@NonNull T t) {
        if (this.done) {
            return;
        }
        if (t == null) {
            this.s.dispose();
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new AppendOnlyLinkedArrayList(4);
                }
                q.add(NotificationLite.next(t));
                return;
            }
            this.emitting = true;
        }
        this.actual.onNext(t);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(@NonNull Throwable t) {
        boolean reportError;
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.done) {
                reportError = true;
            } else {
                if (this.emitting) {
                    this.done = true;
                    AppendOnlyLinkedArrayList<Object> q = this.queue;
                    if (q == null) {
                        q = new AppendOnlyLinkedArrayList(4);
                        this.queue = q;
                    }
                    Object err = NotificationLite.error(t);
                    if (this.delayError) {
                        q.add(err);
                    } else {
                        q.setFirst(err);
                    }
                    return;
                }
                this.done = true;
                this.emitting = true;
                reportError = false;
            }
        }
        if (reportError) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.actual.onError(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new AppendOnlyLinkedArrayList(4);
                }
                q.add(NotificationLite.complete());
                return;
            }
            this.done = true;
            this.emitting = true;
        }
        this.actual.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        AppendOnlyLinkedArrayList<Object> q;
        do {
            SerializedObserver serializedObserver = this;
            synchronized (serializedObserver) {
                q = this.queue;
                if (q == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
        } while (!q.accept(this.actual));
    }
}

