/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.observers;

import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.CompletableObserver;
import nakadi.shadow.io.reactivex.annotations.NonNull;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.disposables.ListCompositeDisposable;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.util.EndConsumerHelper;

public abstract class ResourceCompletableObserver
implements CompletableObserver,
Disposable {
    private final AtomicReference<Disposable> s = new AtomicReference();
    private final ListCompositeDisposable resources = new ListCompositeDisposable();

    public final void add(@NonNull Disposable resource) {
        ObjectHelper.requireNonNull(resource, "resource is null");
        this.resources.add(resource);
    }

    @Override
    public final void onSubscribe(@NonNull Disposable s) {
        if (EndConsumerHelper.setOnce(this.s, s, this.getClass())) {
            this.onStart();
        }
    }

    protected void onStart() {
    }

    @Override
    public final void dispose() {
        if (DisposableHelper.dispose(this.s)) {
            this.resources.dispose();
        }
    }

    @Override
    public final boolean isDisposed() {
        return DisposableHelper.isDisposed(this.s.get());
    }
}

