/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.observables;

import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.annotations.NonNull;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.functions.Consumer;
import nakadi.shadow.io.reactivex.internal.functions.Functions;
import nakadi.shadow.io.reactivex.internal.operators.observable.ObservableAutoConnect;
import nakadi.shadow.io.reactivex.internal.operators.observable.ObservableRefCount;
import nakadi.shadow.io.reactivex.internal.util.ConnectConsumer;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public abstract class ConnectableObservable<T>
extends Observable<T> {
    public abstract void connect(@NonNull Consumer<? super Disposable> var1);

    public final Disposable connect() {
        ConnectConsumer cc = new ConnectConsumer();
        this.connect(cc);
        return cc.disposable;
    }

    @NonNull
    public Observable<T> refCount() {
        return RxJavaPlugins.onAssembly(new ObservableRefCount(this));
    }

    @NonNull
    public Observable<T> autoConnect() {
        return this.autoConnect(1);
    }

    @NonNull
    public Observable<T> autoConnect(int numberOfSubscribers) {
        return this.autoConnect(numberOfSubscribers, Functions.emptyConsumer());
    }

    @NonNull
    public Observable<T> autoConnect(int numberOfSubscribers, @NonNull Consumer<? super Disposable> connection) {
        if (numberOfSubscribers <= 0) {
            this.connect(connection);
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new ObservableAutoConnect(this, numberOfSubscribers, connection));
    }
}

