/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;

public final class VolatileSizeArrayList<T>
extends AtomicInteger
implements List<T> {
    private static final long serialVersionUID = 3972397474470203923L;
    final ArrayList<T> list;

    public VolatileSizeArrayList() {
        this.list = new ArrayList();
    }

    public VolatileSizeArrayList(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    @Override
    public int size() {
        return this.get();
    }

    @Override
    public boolean isEmpty() {
        return this.get() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T e) {
        boolean b = this.list.add(e);
        this.lazySet(this.list.size());
        return b;
    }

    @Override
    public boolean remove(Object o) {
        boolean b = this.list.remove(o);
        this.lazySet(this.list.size());
        return b;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean b = this.list.addAll(c);
        this.lazySet(this.list.size());
        return b;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean b = this.list.addAll(index, c);
        this.lazySet(this.list.size());
        return b;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean b = this.list.removeAll(c);
        this.lazySet(this.list.size());
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean b = this.list.retainAll(c);
        this.lazySet(this.list.size());
        return b;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.lazySet(0);
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
        this.lazySet(this.list.size());
    }

    @Override
    public T remove(int index) {
        T v = this.list.remove(index);
        this.lazySet(this.list.size());
        return v;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VolatileSizeArrayList) {
            return this.list.equals(((VolatileSizeArrayList)obj).list);
        }
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }
}

