/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.exceptions.CompositeException;

public final class ExceptionHelper {
    public static final Throwable TERMINATED = new Termination();

    private ExceptionHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static RuntimeException wrapOrThrow(Throwable error) {
        if (error instanceof Error) {
            throw (Error)error;
        }
        if (error instanceof RuntimeException) {
            return (RuntimeException)error;
        }
        return new RuntimeException(error);
    }

    public static <T> boolean addThrowable(AtomicReference<Throwable> field, Throwable exception) {
        Throwable update;
        Throwable current;
        do {
            if ((current = field.get()) != TERMINATED) continue;
            return false;
        } while (!field.compareAndSet(current, update = current == null ? exception : new CompositeException(current, exception)));
        return true;
    }

    public static <T> Throwable terminate(AtomicReference<Throwable> field) {
        Throwable current = field.get();
        if (current != TERMINATED) {
            current = field.getAndSet(TERMINATED);
        }
        return current;
    }

    public static List<Throwable> flatten(Throwable t) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        ArrayDeque<Throwable> deque = new ArrayDeque<Throwable>();
        deque.offer(t);
        while (!deque.isEmpty()) {
            Throwable e = (Throwable)deque.removeFirst();
            if (e instanceof CompositeException) {
                CompositeException ce = (CompositeException)e;
                List<Throwable> exceptions = ce.getExceptions();
                for (int i = exceptions.size() - 1; i >= 0; --i) {
                    deque.offerFirst(exceptions.get(i));
                }
                continue;
            }
            list.add(e);
        }
        return list;
    }

    static final class Termination
    extends Throwable {
        private static final long serialVersionUID = -4649703670690200604L;

        Termination() {
            super("No further exceptions");
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

