/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.subscriptions;

import nakadi.shadow.io.reactivex.annotations.Nullable;
import nakadi.shadow.io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.org.reactivestreams.Subscriber;

public class DeferredScalarSubscription<T>
extends BasicIntQueueSubscription<T> {
    private static final long serialVersionUID = -2151279923272604993L;
    protected final Subscriber<? super T> actual;
    protected T value;
    static final int NO_REQUEST_NO_VALUE = 0;
    static final int NO_REQUEST_HAS_VALUE = 1;
    static final int HAS_REQUEST_NO_VALUE = 2;
    static final int HAS_REQUEST_HAS_VALUE = 3;
    static final int CANCELLED = 4;
    static final int FUSED_EMPTY = 8;
    static final int FUSED_READY = 16;
    static final int FUSED_CONSUMED = 32;

    public DeferredScalarSubscription(Subscriber<? super T> actual) {
        this.actual = actual;
    }

    @Override
    public final void request(long n) {
        if (SubscriptionHelper.validate(n)) {
            do {
                T v;
                int state;
                if (((state = this.get()) & 0xFFFFFFFE) != 0) {
                    return;
                }
                if (state != 1) continue;
                if (this.compareAndSet(1, 3) && (v = this.value) != null) {
                    this.value = null;
                    Subscriber<T> a = this.actual;
                    a.onNext(v);
                    if (this.get() != 4) {
                        a.onComplete();
                    }
                }
                return;
            } while (!this.compareAndSet(0, 2));
            return;
        }
    }

    public final void complete(T v) {
        int state = this.get();
        do {
            if (state == 8) {
                this.value = v;
                this.lazySet(16);
                Subscriber<T> a = this.actual;
                a.onNext(v);
                if (this.get() != 4) {
                    a.onComplete();
                }
                return;
            }
            if ((state & 0xFFFFFFFD) != 0) {
                return;
            }
            if (state == 2) {
                this.lazySet(3);
                Subscriber<T> a = this.actual;
                a.onNext(v);
                if (this.get() != 4) {
                    a.onComplete();
                }
                return;
            }
            this.value = v;
            if (!this.compareAndSet(0, 1)) continue;
            return;
        } while ((state = this.get()) != 4);
        this.value = null;
    }

    @Override
    public final int requestFusion(int mode) {
        if ((mode & 2) != 0) {
            this.lazySet(8);
            return 2;
        }
        return 0;
    }

    @Override
    @Nullable
    public final T poll() {
        if (this.get() == 16) {
            this.lazySet(32);
            T v = this.value;
            this.value = null;
            return v;
        }
        return null;
    }

    @Override
    public final boolean isEmpty() {
        return this.get() != 16;
    }

    @Override
    public final void clear() {
        this.lazySet(32);
        this.value = null;
    }

    @Override
    public void cancel() {
        this.set(4);
        this.value = null;
    }

    public final boolean isCancelled() {
        return this.get() == 4;
    }

    public final boolean tryCancel() {
        return this.getAndSet(4) != 4;
    }
}

