/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.subscribers;

import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.internal.fuseable.QueueSubscription;
import nakadi.shadow.io.reactivex.internal.fuseable.SimpleQueue;
import nakadi.shadow.io.reactivex.internal.subscribers.InnerQueuedSubscriberSupport;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.internal.util.QueueDrainHelper;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class InnerQueuedSubscriber<T>
extends AtomicReference<Subscription>
implements FlowableSubscriber<T>,
Subscription {
    private static final long serialVersionUID = 22876611072430776L;
    final InnerQueuedSubscriberSupport<T> parent;
    final int prefetch;
    final int limit;
    volatile SimpleQueue<T> queue;
    volatile boolean done;
    long produced;
    int fusionMode;

    public InnerQueuedSubscriber(InnerQueuedSubscriberSupport<T> parent, int prefetch) {
        this.parent = parent;
        this.prefetch = prefetch;
        this.limit = prefetch - (prefetch >> 2);
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this, s)) {
            if (s instanceof QueueSubscription) {
                QueueSubscription qs = (QueueSubscription)s;
                int m = qs.requestFusion(3);
                if (m == 1) {
                    this.fusionMode = m;
                    this.queue = qs;
                    this.done = true;
                    this.parent.innerComplete(this);
                    return;
                }
                if (m == 2) {
                    this.fusionMode = m;
                    this.queue = qs;
                    QueueDrainHelper.request(s, this.prefetch);
                    return;
                }
            }
            this.queue = QueueDrainHelper.createQueue(this.prefetch);
            QueueDrainHelper.request(s, this.prefetch);
        }
    }

    @Override
    public void onNext(T t) {
        if (this.fusionMode == 0) {
            this.parent.innerNext(this, t);
        } else {
            this.parent.drain();
        }
    }

    @Override
    public void onError(Throwable t) {
        this.parent.innerError(this, t);
    }

    @Override
    public void onComplete() {
        this.parent.innerComplete(this);
    }

    @Override
    public void request(long n) {
        if (this.fusionMode != 1) {
            long p = this.produced + n;
            if (p >= (long)this.limit) {
                this.produced = 0L;
                ((Subscription)this.get()).request(p);
            } else {
                this.produced = p;
            }
        }
    }

    public void requestOne() {
        if (this.fusionMode != 1) {
            long p = this.produced + 1L;
            if (p == (long)this.limit) {
                this.produced = 0L;
                ((Subscription)this.get()).request(p);
            } else {
                this.produced = p;
            }
        }
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this);
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone() {
        this.done = true;
    }

    public SimpleQueue<T> queue() {
        return this.queue;
    }
}

