/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.subscribers;

import java.util.concurrent.CountDownLatch;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.internal.util.BlockingHelper;
import nakadi.shadow.io.reactivex.internal.util.ExceptionHelper;
import nakadi.shadow.org.reactivestreams.Subscription;

public abstract class BlockingBaseSubscriber<T>
extends CountDownLatch
implements FlowableSubscriber<T> {
    T value;
    Throwable error;
    Subscription s;
    volatile boolean cancelled;

    public BlockingBaseSubscriber() {
        super(1);
    }

    @Override
    public final void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate(this.s, s)) {
            this.s = s;
            if (!this.cancelled) {
                s.request(Long.MAX_VALUE);
                if (this.cancelled) {
                    this.s = SubscriptionHelper.CANCELLED;
                    s.cancel();
                }
            }
        }
    }

    @Override
    public final void onComplete() {
        this.countDown();
    }

    public final T blockingGet() {
        Throwable e;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex) {
                Subscription s = this.s;
                this.s = SubscriptionHelper.CANCELLED;
                if (s != null) {
                    s.cancel();
                }
                throw ExceptionHelper.wrapOrThrow(ex);
            }
        }
        if ((e = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(e);
        }
        return this.value;
    }
}

