/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.schedulers;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.internal.schedulers.RxThreadFactory;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class SchedulerPoolFactory {
    static final String PURGE_ENABLED_KEY = "nakadi.shadow.rx2.purge-enabled";
    public static final boolean PURGE_ENABLED;
    static final String PURGE_PERIOD_SECONDS_KEY = "nakadi.shadow.rx2.purge-period-seconds";
    public static final int PURGE_PERIOD_SECONDS;
    static final AtomicReference<ScheduledExecutorService> PURGE_THREAD;
    static final Map<ScheduledThreadPoolExecutor, Object> POOLS;

    private SchedulerPoolFactory() {
        throw new IllegalStateException("No instances!");
    }

    public static void start() {
        ScheduledExecutorService curr;
        while ((curr = PURGE_THREAD.get()) == null || curr.isShutdown()) {
            ScheduledExecutorService next = Executors.newScheduledThreadPool(1, new RxThreadFactory("RxSchedulerPurge"));
            if (PURGE_THREAD.compareAndSet(curr, next)) {
                next.scheduleAtFixedRate(new ScheduledTask(), PURGE_PERIOD_SECONDS, PURGE_PERIOD_SECONDS, TimeUnit.SECONDS);
                return;
            }
            next.shutdownNow();
        }
        return;
    }

    public static void shutdown() {
        PURGE_THREAD.get().shutdownNow();
        POOLS.clear();
    }

    public static ScheduledExecutorService create(ThreadFactory factory) {
        ScheduledExecutorService exec = Executors.newScheduledThreadPool(1, factory);
        if (exec instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor e = (ScheduledThreadPoolExecutor)exec;
            POOLS.put(e, exec);
        }
        return exec;
    }

    static {
        PURGE_THREAD = new AtomicReference();
        POOLS = new ConcurrentHashMap<ScheduledThreadPoolExecutor, Object>();
        boolean purgeEnable = true;
        int purgePeriod = 1;
        Properties properties = System.getProperties();
        if (properties.containsKey(PURGE_ENABLED_KEY) && (purgeEnable = Boolean.getBoolean(PURGE_ENABLED_KEY)) && properties.containsKey(PURGE_PERIOD_SECONDS_KEY)) {
            purgePeriod = Integer.getInteger(PURGE_PERIOD_SECONDS_KEY, purgePeriod);
        }
        PURGE_ENABLED = purgeEnable;
        PURGE_PERIOD_SECONDS = purgePeriod;
        SchedulerPoolFactory.start();
    }

    static final class ScheduledTask
    implements Runnable {
        ScheduledTask() {
        }

        @Override
        public void run() {
            try {
                for (ScheduledThreadPoolExecutor e : new ArrayList<ScheduledThreadPoolExecutor>(POOLS.keySet())) {
                    if (e.isShutdown()) {
                        POOLS.remove(e);
                        continue;
                    }
                    e.purge();
                }
            }
            catch (Throwable e) {
                RxJavaPlugins.onError(e);
            }
        }
    }
}

