/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.schedulers;

import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import nakadi.shadow.io.reactivex.Scheduler;
import nakadi.shadow.io.reactivex.annotations.NonNull;
import nakadi.shadow.io.reactivex.annotations.Nullable;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableContainer;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.internal.schedulers.ScheduledDirectPeriodicTask;
import nakadi.shadow.io.reactivex.internal.schedulers.ScheduledDirectTask;
import nakadi.shadow.io.reactivex.internal.schedulers.ScheduledRunnable;
import nakadi.shadow.io.reactivex.internal.schedulers.SchedulerPoolFactory;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public class NewThreadWorker
extends Scheduler.Worker
implements Disposable {
    private final ScheduledExecutorService executor;
    volatile boolean disposed;

    public NewThreadWorker(ThreadFactory threadFactory) {
        this.executor = SchedulerPoolFactory.create(threadFactory);
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable run) {
        return this.schedule(run, 0L, null);
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable action, long delayTime, @NonNull TimeUnit unit) {
        if (this.disposed) {
            return EmptyDisposable.INSTANCE;
        }
        return this.scheduleActual(action, delayTime, unit, null);
    }

    public Disposable scheduleDirect(Runnable run, long delayTime, TimeUnit unit) {
        ScheduledDirectTask task = new ScheduledDirectTask(RxJavaPlugins.onSchedule(run));
        try {
            Future<Void> f = delayTime <= 0L ? this.executor.submit(task) : this.executor.schedule(task, delayTime, unit);
            task.setFuture(f);
            return task;
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    public Disposable schedulePeriodicallyDirect(Runnable run, long initialDelay, long period, TimeUnit unit) {
        ScheduledDirectPeriodicTask task = new ScheduledDirectPeriodicTask(RxJavaPlugins.onSchedule(run));
        try {
            ScheduledFuture<?> f = this.executor.scheduleAtFixedRate(task, initialDelay, period, unit);
            task.setFuture(f);
            return task;
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    @NonNull
    public ScheduledRunnable scheduleActual(Runnable run, long delayTime, @NonNull TimeUnit unit, @Nullable DisposableContainer parent) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        ScheduledRunnable sr = new ScheduledRunnable(decoratedRun, parent);
        if (parent != null && !parent.add(sr)) {
            return sr;
        }
        try {
            Future<Object> f = delayTime <= 0L ? this.executor.submit(sr) : this.executor.schedule(sr, delayTime, unit);
            sr.setFuture(f);
        }
        catch (RejectedExecutionException ex) {
            if (parent != null) {
                parent.remove(sr);
            }
            RxJavaPlugins.onError(ex);
        }
        return sr;
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.executor.shutdownNow();
        }
    }

    public void shutdown() {
        if (!this.disposed) {
            this.disposed = true;
            this.executor.shutdown();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

