/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.schedulers;

import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.functions.Functions;

abstract class AbstractDirectTask
extends AtomicReference<Future<?>>
implements Disposable {
    private static final long serialVersionUID = 1811839108042568751L;
    protected final Runnable runnable;
    protected Thread runner;
    protected static final FutureTask<Void> FINISHED = new FutureTask<Object>(Functions.EMPTY_RUNNABLE, null);
    protected static final FutureTask<Void> DISPOSED = new FutureTask<Object>(Functions.EMPTY_RUNNABLE, null);

    AbstractDirectTask(Runnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public final void dispose() {
        Future f = (Future)this.get();
        if (f != FINISHED && f != DISPOSED && this.compareAndSet(f, DISPOSED) && f != null) {
            f.cancel(this.runner != Thread.currentThread());
        }
    }

    @Override
    public final boolean isDisposed() {
        Future f = (Future)this.get();
        return f == FINISHED || f == DISPOSED;
    }

    public final void setFuture(Future<?> future) {
        Future f;
        while ((f = (Future)this.get()) != FINISHED) {
            if (f == DISPOSED) {
                future.cancel(this.runner != Thread.currentThread());
                break;
            }
            if (!this.compareAndSet(f, future)) continue;
            break;
        }
    }
}

