/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.single;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Single;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.SingleSource;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Function;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.operators.single.SingleMap;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class SingleZipArray<T, R>
extends Single<R> {
    final SingleSource<? extends T>[] sources;
    final Function<? super Object[], ? extends R> zipper;

    public SingleZipArray(SingleSource<? extends T>[] sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> observer) {
        SingleSource<? extends T>[] sources = this.sources;
        int n = sources.length;
        if (n == 1) {
            sources[0].subscribe(new SingleMap.MapSingleObserver(observer, new SingletonArrayFunc()));
            return;
        }
        ZipCoordinator parent = new ZipCoordinator(observer, n, this.zipper);
        observer.onSubscribe(parent);
        for (int i = 0; i < n; ++i) {
            if (parent.isDisposed()) {
                return;
            }
            SingleSource source = sources[i];
            if (source == null) {
                parent.innerError(new NullPointerException("One of the sources is null"), i);
                return;
            }
            source.subscribe(parent.observers[i]);
        }
    }

    final class SingletonArrayFunc
    implements Function<T, R> {
        SingletonArrayFunc() {
        }

        @Override
        public R apply(T t) throws Exception {
            return SingleZipArray.this.zipper.apply((Object[])new Object[]{t});
        }
    }

    static final class ZipSingleObserver<T>
    extends AtomicReference<Disposable>
    implements SingleObserver<T> {
        private static final long serialVersionUID = 3323743579927613702L;
        final ZipCoordinator<T, ?> parent;
        final int index;

        ZipSingleObserver(ZipCoordinator<T, ?> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onSuccess(T value) {
            this.parent.innerSuccess(value, this.index);
        }

        @Override
        public void onError(Throwable e) {
            this.parent.innerError(e, this.index);
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = -5556924161382950569L;
        final SingleObserver<? super R> actual;
        final Function<? super Object[], ? extends R> zipper;
        final ZipSingleObserver<T>[] observers;
        final Object[] values;

        ZipCoordinator(SingleObserver<? super R> observer, int n, Function<? super Object[], ? extends R> zipper) {
            super(n);
            this.actual = observer;
            this.zipper = zipper;
            ZipSingleObserver[] o = new ZipSingleObserver[n];
            for (int i = 0; i < n; ++i) {
                o[i] = new ZipSingleObserver(this, i);
            }
            this.observers = o;
            this.values = new Object[n];
        }

        @Override
        public boolean isDisposed() {
            return this.get() <= 0;
        }

        @Override
        public void dispose() {
            if (this.getAndSet(0) > 0) {
                for (ZipSingleObserver<T> d : this.observers) {
                    d.dispose();
                }
            }
        }

        void innerSuccess(T value, int index) {
            this.values[index] = value;
            if (this.decrementAndGet() == 0) {
                R v;
                try {
                    v = ObjectHelper.requireNonNull(this.zipper.apply((Object[])this.values), "The zipper returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.actual.onError(ex);
                    return;
                }
                this.actual.onSuccess(v);
            }
        }

        void disposeExcept(int index) {
            int i;
            ZipSingleObserver<T>[] observers = this.observers;
            int n = observers.length;
            for (i = 0; i < index; ++i) {
                observers[i].dispose();
            }
            for (i = index + 1; i < n; ++i) {
                observers[i].dispose();
            }
        }

        void innerError(Throwable ex, int index) {
            if (this.getAndSet(0) > 0) {
                this.disposeExcept(index);
                this.actual.onError(ex);
            } else {
                RxJavaPlugins.onError(ex);
            }
        }
    }
}

