/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.single;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import nakadi.shadow.io.reactivex.Scheduler;
import nakadi.shadow.io.reactivex.Single;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.SingleSource;
import nakadi.shadow.io.reactivex.disposables.CompositeDisposable;
import nakadi.shadow.io.reactivex.disposables.Disposable;

public final class SingleTimeout<T>
extends Single<T> {
    final SingleSource<T> source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final SingleSource<? extends T> other;

    public SingleTimeout(SingleSource<T> source, long timeout, TimeUnit unit, Scheduler scheduler, SingleSource<? extends T> other) {
        this.source = source;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> s) {
        CompositeDisposable set = new CompositeDisposable();
        s.onSubscribe(set);
        AtomicBoolean once = new AtomicBoolean();
        Disposable timer = this.scheduler.scheduleDirect(new TimeoutDispose(once, set, s), this.timeout, this.unit);
        set.add(timer);
        this.source.subscribe(new TimeoutObserver(once, set, s));
    }

    final class TimeoutObserver
    implements SingleObserver<T> {
        private final AtomicBoolean once;
        private final CompositeDisposable set;
        private final SingleObserver<? super T> s;

        TimeoutObserver(AtomicBoolean once, CompositeDisposable set, SingleObserver<? super T> s) {
            this.once = once;
            this.set = set;
            this.s = s;
        }

        @Override
        public void onError(Throwable e) {
            if (this.once.compareAndSet(false, true)) {
                this.set.dispose();
                this.s.onError(e);
            }
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.set.add(d);
        }

        @Override
        public void onSuccess(T value) {
            if (this.once.compareAndSet(false, true)) {
                this.set.dispose();
                this.s.onSuccess(value);
            }
        }
    }

    final class TimeoutDispose
    implements Runnable {
        private final AtomicBoolean once;
        final CompositeDisposable set;
        final SingleObserver<? super T> s;

        TimeoutDispose(AtomicBoolean once, CompositeDisposable set, SingleObserver<? super T> s) {
            this.once = once;
            this.set = set;
            this.s = s;
        }

        @Override
        public void run() {
            if (this.once.compareAndSet(false, true)) {
                if (SingleTimeout.this.other != null) {
                    this.set.clear();
                    SingleTimeout.this.other.subscribe(new TimeoutObserver());
                } else {
                    this.set.dispose();
                    this.s.onError(new TimeoutException());
                }
            }
        }

        final class TimeoutObserver
        implements SingleObserver<T> {
            TimeoutObserver() {
            }

            @Override
            public void onError(Throwable e) {
                TimeoutDispose.this.set.dispose();
                TimeoutDispose.this.s.onError(e);
            }

            @Override
            public void onSubscribe(Disposable d) {
                TimeoutDispose.this.set.add(d);
            }

            @Override
            public void onSuccess(T value) {
                TimeoutDispose.this.set.dispose();
                TimeoutDispose.this.s.onSuccess(value);
            }
        }
    }
}

