/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.single;

import java.util.concurrent.atomic.AtomicInteger;
import nakadi.shadow.io.reactivex.Single;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.SingleSource;
import nakadi.shadow.io.reactivex.disposables.CompositeDisposable;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class SingleEquals<T>
extends Single<Boolean> {
    final SingleSource<? extends T> first;
    final SingleSource<? extends T> second;

    public SingleEquals(SingleSource<? extends T> first, SingleSource<? extends T> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super Boolean> s) {
        AtomicInteger count = new AtomicInteger();
        Object[] values = new Object[]{null, null};
        CompositeDisposable set = new CompositeDisposable();
        s.onSubscribe(set);
        this.first.subscribe(new InnerObserver(0, set, values, s, count));
        this.second.subscribe(new InnerObserver(1, set, values, s, count));
    }

    static class InnerObserver<T>
    implements SingleObserver<T> {
        final int index;
        final CompositeDisposable set;
        final Object[] values;
        final SingleObserver<? super Boolean> s;
        final AtomicInteger count;

        InnerObserver(int index, CompositeDisposable set, Object[] values, SingleObserver<? super Boolean> s, AtomicInteger count) {
            this.index = index;
            this.set = set;
            this.values = values;
            this.s = s;
            this.count = count;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.set.add(d);
        }

        @Override
        public void onSuccess(T value) {
            this.values[this.index] = value;
            if (this.count.incrementAndGet() == 2) {
                this.s.onSuccess((Boolean)ObjectHelper.equals(this.values[0], this.values[1]));
            }
        }

        @Override
        public void onError(Throwable e) {
            int state;
            do {
                if ((state = this.count.get()) < 2) continue;
                RxJavaPlugins.onError(e);
                return;
            } while (!this.count.compareAndSet(state, 2));
            this.set.dispose();
            this.s.onError(e);
        }
    }
}

