/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.single;

import nakadi.shadow.io.reactivex.Single;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.SingleSource;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.CompositeException;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.BiConsumer;

public final class SingleDoOnEvent<T>
extends Single<T> {
    final SingleSource<T> source;
    final BiConsumer<? super T, ? super Throwable> onEvent;

    public SingleDoOnEvent(SingleSource<T> source, BiConsumer<? super T, ? super Throwable> onEvent) {
        this.source = source;
        this.onEvent = onEvent;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> s) {
        this.source.subscribe(new DoOnEvent(s));
    }

    final class DoOnEvent
    implements SingleObserver<T> {
        private final SingleObserver<? super T> s;

        DoOnEvent(SingleObserver<? super T> s) {
            this.s = s;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.s.onSubscribe(d);
        }

        @Override
        public void onSuccess(T value) {
            try {
                SingleDoOnEvent.this.onEvent.accept(value, null);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.s.onError(ex);
                return;
            }
            this.s.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            try {
                SingleDoOnEvent.this.onEvent.accept(null, e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                e = new CompositeException(e, ex);
            }
            this.s.onError(e);
        }
    }
}

