/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.single;

import java.util.concurrent.atomic.AtomicBoolean;
import nakadi.shadow.io.reactivex.Single;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.SingleSource;
import nakadi.shadow.io.reactivex.disposables.CompositeDisposable;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class SingleAmb<T>
extends Single<T> {
    private final SingleSource<? extends T>[] sources;
    private final Iterable<? extends SingleSource<? extends T>> sourcesIterable;

    public SingleAmb(SingleSource<? extends T>[] sources, Iterable<? extends SingleSource<? extends T>> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> s) {
        SingleSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new SingleSource[8];
            try {
                for (SingleSource<? extends T> singleSource : this.sourcesIterable) {
                    if (singleSource == null) {
                        EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), s);
                        return;
                    }
                    if (count == sources.length) {
                        SingleSource[] b = new SingleSource[count + (count >> 2)];
                        System.arraycopy(sources, 0, b, 0, count);
                        sources = b;
                    }
                    sources[count++] = singleSource;
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                EmptyDisposable.error(e, s);
                return;
            }
        } else {
            count = sources.length;
        }
        CompositeDisposable set = new CompositeDisposable();
        AmbSingleObserver<T> ambSingleObserver = new AmbSingleObserver<T>(s, set);
        s.onSubscribe(set);
        for (int i = 0; i < count; ++i) {
            SingleSource<T> s1 = sources[i];
            if (ambSingleObserver.get()) {
                return;
            }
            if (s1 == null) {
                set.dispose();
                NullPointerException e = new NullPointerException("One of the sources is null");
                if (ambSingleObserver.compareAndSet(false, true)) {
                    s.onError(e);
                } else {
                    RxJavaPlugins.onError(e);
                }
                return;
            }
            s1.subscribe(ambSingleObserver);
        }
    }

    static final class AmbSingleObserver<T>
    extends AtomicBoolean
    implements SingleObserver<T> {
        private static final long serialVersionUID = -1944085461036028108L;
        final CompositeDisposable set;
        final SingleObserver<? super T> s;

        AmbSingleObserver(SingleObserver<? super T> s, CompositeDisposable set) {
            this.s = s;
            this.set = set;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.set.add(d);
        }

        @Override
        public void onSuccess(T value) {
            if (this.compareAndSet(false, true)) {
                this.set.dispose();
                this.s.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.compareAndSet(false, true)) {
                this.set.dispose();
                this.s.onError(e);
            } else {
                RxJavaPlugins.onError(e);
            }
        }
    }
}

