/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.parallel;

import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Predicate;
import nakadi.shadow.io.reactivex.internal.fuseable.ConditionalSubscriber;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.parallel.ParallelFlowable;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class ParallelFilter<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<T> source;
    final Predicate<? super T> predicate;

    public ParallelFilter(ParallelFlowable<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> a = subscribers[i];
            parents[i] = a instanceof ConditionalSubscriber ? new ParallelFilterConditionalSubscriber<T>((ConditionalSubscriber)a, this.predicate) : new ParallelFilterSubscriber<T>(a, this.predicate);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelFilterConditionalSubscriber<T>
    extends BaseFilterSubscriber<T> {
        final ConditionalSubscriber<? super T> actual;

        ParallelFilterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Predicate<? super T> predicate) {
            super(predicate);
            this.actual = actual;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (!this.done) {
                boolean b;
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.cancel();
                    this.onError(ex);
                    return false;
                }
                if (b) {
                    return this.actual.tryOnNext(t);
                }
            }
            return false;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.actual.onComplete();
            }
        }
    }

    static final class ParallelFilterSubscriber<T>
    extends BaseFilterSubscriber<T> {
        final Subscriber<? super T> actual;

        ParallelFilterSubscriber(Subscriber<? super T> actual, Predicate<? super T> predicate) {
            super(predicate);
            this.actual = actual;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (!this.done) {
                boolean b;
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.cancel();
                    this.onError(ex);
                    return false;
                }
                if (b) {
                    this.actual.onNext(t);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.actual.onComplete();
            }
        }
    }

    static abstract class BaseFilterSubscriber<T>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Predicate<? super T> predicate;
        Subscription s;
        boolean done;

        BaseFilterSubscriber(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        @Override
        public final void request(long n) {
            this.s.request(n);
        }

        @Override
        public final void cancel() {
            this.s.cancel();
        }

        @Override
        public final void onNext(T t) {
            if (!this.tryOnNext(t) && !this.done) {
                this.s.request(1L);
            }
        }
    }
}

