/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;

public final class ObserverResourceWrapper<T>
extends AtomicReference<Disposable>
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -8612022020200669122L;
    final Observer<? super T> actual;
    final AtomicReference<Disposable> subscription = new AtomicReference();

    public ObserverResourceWrapper(Observer<? super T> actual) {
        this.actual = actual;
    }

    @Override
    public void onSubscribe(Disposable s) {
        if (DisposableHelper.setOnce(this.subscription, s)) {
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t) {
        this.actual.onNext(t);
    }

    @Override
    public void onError(Throwable t) {
        this.dispose();
        this.actual.onError(t);
    }

    @Override
    public void onComplete() {
        this.dispose();
        this.actual.onComplete();
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this.subscription);
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.subscription.get() == DisposableHelper.DISPOSED;
    }

    public void setResource(Disposable resource) {
        DisposableHelper.set(this, resource);
    }
}

