/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.Iterator;
import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.BiFunction;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableZipIterable<T, U, V>
extends Observable<V> {
    final Observable<? extends T> source;
    final Iterable<U> other;
    final BiFunction<? super T, ? super U, ? extends V> zipper;

    public ObservableZipIterable(Observable<? extends T> source, Iterable<U> other, BiFunction<? super T, ? super U, ? extends V> zipper) {
        this.source = source;
        this.other = other;
        this.zipper = zipper;
    }

    @Override
    public void subscribeActual(Observer<? super V> t) {
        boolean b;
        Iterator<U> it;
        try {
            it = ObjectHelper.requireNonNull(this.other.iterator(), "The iterator returned by other is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t);
            return;
        }
        try {
            b = it.hasNext();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t);
            return;
        }
        if (!b) {
            EmptyDisposable.complete(t);
            return;
        }
        this.source.subscribe(new ZipIterableObserver<T, U, V>(t, it, this.zipper));
    }

    static final class ZipIterableObserver<T, U, V>
    implements Observer<T>,
    Disposable {
        final Observer<? super V> actual;
        final Iterator<U> iterator;
        final BiFunction<? super T, ? super U, ? extends V> zipper;
        Disposable s;
        boolean done;

        ZipIterableObserver(Observer<? super V> actual, Iterator<U> iterator, BiFunction<? super T, ? super U, ? extends V> zipper) {
            this.actual = actual;
            this.iterator = iterator;
            this.zipper = zipper;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            boolean b;
            V v;
            U u;
            if (this.done) {
                return;
            }
            try {
                u = ObjectHelper.requireNonNull(this.iterator.next(), "The iterator returned a null value");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.error(e);
                return;
            }
            try {
                v = ObjectHelper.requireNonNull(this.zipper.apply(t, u), "The zipper function returned a null value");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.error(e);
                return;
            }
            this.actual.onNext(v);
            try {
                b = this.iterator.hasNext();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.error(e);
                return;
            }
            if (!b) {
                this.done = true;
                this.s.dispose();
                this.actual.onComplete();
            }
        }

        void error(Throwable e) {
            this.done = true;
            this.s.dispose();
            this.actual.onError(e);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }
    }
}

