/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.BiFunction;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import nakadi.shadow.io.reactivex.observers.SerializedObserver;

public final class ObservableWithLatestFrom<T, U, R>
extends AbstractObservableWithUpstream<T, R> {
    final BiFunction<? super T, ? super U, ? extends R> combiner;
    final ObservableSource<? extends U> other;

    public ObservableWithLatestFrom(ObservableSource<T> source, BiFunction<? super T, ? super U, ? extends R> combiner, ObservableSource<? extends U> other) {
        super(source);
        this.combiner = combiner;
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super R> t) {
        SerializedObserver<R> serial = new SerializedObserver<R>(t);
        WithLatestFromObserver<? super T, ? super U, ? extends R> wlf = new WithLatestFromObserver<T, U, R>(serial, this.combiner);
        serial.onSubscribe(wlf);
        this.other.subscribe(new WithLastFrom(wlf));
        this.source.subscribe(wlf);
    }

    final class WithLastFrom
    implements Observer<U> {
        private final WithLatestFromObserver<T, U, R> wlf;

        WithLastFrom(WithLatestFromObserver<T, U, R> wlf) {
            this.wlf = wlf;
        }

        @Override
        public void onSubscribe(Disposable s) {
            this.wlf.setOther(s);
        }

        @Override
        public void onNext(U t) {
            this.wlf.lazySet(t);
        }

        @Override
        public void onError(Throwable t) {
            this.wlf.otherError(t);
        }

        @Override
        public void onComplete() {
        }
    }

    static final class WithLatestFromObserver<T, U, R>
    extends AtomicReference<U>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -312246233408980075L;
        final Observer<? super R> actual;
        final BiFunction<? super T, ? super U, ? extends R> combiner;
        final AtomicReference<Disposable> s = new AtomicReference();
        final AtomicReference<Disposable> other = new AtomicReference();

        WithLatestFromObserver(Observer<? super R> actual, BiFunction<? super T, ? super U, ? extends R> combiner) {
            this.actual = actual;
            this.combiner = combiner;
        }

        @Override
        public void onSubscribe(Disposable s) {
            DisposableHelper.setOnce(this.s, s);
        }

        @Override
        public void onNext(T t) {
            Object u = this.get();
            if (u != null) {
                R r;
                try {
                    r = ObjectHelper.requireNonNull(this.combiner.apply(t, u), "The combiner returned a null value");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.dispose();
                    this.actual.onError(e);
                    return;
                }
                this.actual.onNext(r);
            }
        }

        @Override
        public void onError(Throwable t) {
            DisposableHelper.dispose(this.other);
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this.other);
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.s);
            DisposableHelper.dispose(this.other);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.s.get());
        }

        public boolean setOther(Disposable o) {
            return DisposableHelper.setOnce(this.other, o);
        }

        public void otherError(Throwable e) {
            DisposableHelper.dispose(this.s);
            this.actual.onError(e);
        }
    }
}

