/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.atomic.AtomicBoolean;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.Scheduler;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableUnsubscribeOn<T>
extends AbstractObservableWithUpstream<T, T> {
    final Scheduler scheduler;

    public ObservableUnsubscribeOn(ObservableSource<T> source, Scheduler scheduler) {
        super(source);
        this.scheduler = scheduler;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new UnsubscribeObserver<T>(t, this.scheduler));
    }

    static final class UnsubscribeObserver<T>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 1015244841293359600L;
        final Observer<? super T> actual;
        final Scheduler scheduler;
        Disposable s;

        UnsubscribeObserver(Observer<? super T> actual, Scheduler scheduler) {
            this.actual = actual;
            this.scheduler = scheduler;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.get()) {
                this.actual.onNext(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.get()) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.get()) {
                this.actual.onComplete();
            }
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.scheduler.scheduleDirect(new DisposeTask());
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }

        final class DisposeTask
        implements Runnable {
            DisposeTask() {
            }

            @Override
            public void run() {
                UnsubscribeObserver.this.s.dispose();
            }
        }
    }
}

