/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.Collection;
import java.util.concurrent.Callable;
import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.Single;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.internal.functions.Functions;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.fuseable.FuseToObservable;
import nakadi.shadow.io.reactivex.internal.operators.observable.ObservableToList;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableToListSingle<T, U extends Collection<? super T>>
extends Single<U>
implements FuseToObservable<U> {
    final ObservableSource<T> source;
    final Callable<U> collectionSupplier;

    public ObservableToListSingle(ObservableSource<T> source, int defaultCapacityHint) {
        this.source = source;
        this.collectionSupplier = Functions.createArrayList(defaultCapacityHint);
    }

    public ObservableToListSingle(ObservableSource<T> source, Callable<U> collectionSupplier) {
        this.source = source;
        this.collectionSupplier = collectionSupplier;
    }

    @Override
    public void subscribeActual(SingleObserver<? super U> t) {
        Collection coll;
        try {
            coll = (Collection)ObjectHelper.requireNonNull(this.collectionSupplier.call(), "The collectionSupplier returned a null collection. Null values are generally not allowed in 2.x operators and sources.");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t);
            return;
        }
        this.source.subscribe(new ToListObserver(t, coll));
    }

    @Override
    public Observable<U> fuseToObservable() {
        return RxJavaPlugins.onAssembly(new ObservableToList<T, U>(this.source, this.collectionSupplier));
    }

    static final class ToListObserver<T, U extends Collection<? super T>>
    implements Observer<T>,
    Disposable {
        final SingleObserver<? super U> actual;
        U collection;
        Disposable s;

        ToListObserver(SingleObserver<? super U> actual, U collection) {
            this.actual = actual;
            this.collection = collection;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            this.collection.add(t);
        }

        @Override
        public void onError(Throwable t) {
            this.collection = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            U c = this.collection;
            this.collection = null;
            this.actual.onSuccess(c);
        }
    }
}

