/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.Scheduler;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import nakadi.shadow.io.reactivex.observers.SerializedObserver;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableThrottleFirstTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;

    public ObservableThrottleFirstTimed(ObservableSource<T> source, long timeout, TimeUnit unit, Scheduler scheduler) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new DebounceTimedObserver<T>(new SerializedObserver<T>(t), this.timeout, this.unit, this.scheduler.createWorker()));
    }

    static final class DebounceTimedObserver<T>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 786994795061867455L;
        final Observer<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        Disposable s;
        volatile boolean gate;
        boolean done;

        DebounceTimedObserver(Observer<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.gate && !this.done) {
                this.gate = true;
                this.actual.onNext(t);
                Disposable d = (Disposable)this.get();
                if (d != null) {
                    d.dispose();
                }
                DisposableHelper.replace(this, this.worker.schedule(this, this.timeout, this.unit));
            }
        }

        @Override
        public void run() {
            this.gate = false;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
            } else {
                this.done = true;
                this.actual.onError(t);
                this.worker.dispose();
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.actual.onComplete();
                this.worker.dispose();
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
            this.worker.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.worker.isDisposed();
        }
    }
}

