/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.Scheduler;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import nakadi.shadow.io.reactivex.internal.queue.SpscLinkedArrayQueue;

public final class ObservableTakeLastTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long count;
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    final boolean delayError;

    public ObservableTakeLastTimed(ObservableSource<T> source, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
        super(source);
        this.count = count;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new TakeLastTimedObserver<T>(t, this.count, this.time, this.unit, this.scheduler, this.bufferSize, this.delayError));
    }

    static final class TakeLastTimedObserver<T>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -5677354903406201275L;
        final Observer<? super T> actual;
        final long count;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;
        final SpscLinkedArrayQueue<Object> queue;
        final boolean delayError;
        Disposable d;
        volatile boolean cancelled;
        Throwable error;

        TakeLastTimedObserver(Observer<? super T> actual, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
            this.actual = actual;
            this.count = count;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            long ts;
            SpscLinkedArrayQueue<Object> q = this.queue;
            long now = this.scheduler.now(this.unit);
            long time = this.time;
            long c = this.count;
            boolean unbounded = c == Long.MAX_VALUE;
            q.offer(now, t);
            while (!q.isEmpty() && ((ts = ((Long)q.peek()).longValue()) <= now - time || !unbounded && (long)(q.size() >> 1) > c)) {
                q.poll();
                q.poll();
            }
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.drain();
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.d.dispose();
                if (this.compareAndSet(false, true)) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void drain() {
            if (!this.compareAndSet(false, true)) {
                return;
            }
            Observer<Object> a = this.actual;
            SpscLinkedArrayQueue<Object> q = this.queue;
            boolean delayError = this.delayError;
            while (true) {
                boolean empty;
                Throwable ex;
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                if (!delayError && (ex = this.error) != null) {
                    q.clear();
                    a.onError(ex);
                    return;
                }
                Object ts = q.poll();
                boolean bl = empty = ts == null;
                if (empty) {
                    Throwable ex2 = this.error;
                    if (ex2 != null) {
                        a.onError(ex2);
                    } else {
                        a.onComplete();
                    }
                    return;
                }
                Object o = q.poll();
                if ((Long)ts < this.scheduler.now(this.unit) - this.time) continue;
                a.onNext(o);
            }
        }
    }
}

