/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Predicate;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableSkipWhile<T>
extends AbstractObservableWithUpstream<T, T> {
    final Predicate<? super T> predicate;

    public ObservableSkipWhile(ObservableSource<T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = predicate;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        this.source.subscribe(new SkipWhileObserver<T>(s, this.predicate));
    }

    static final class SkipWhileObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> actual;
        final Predicate<? super T> predicate;
        Disposable s;
        boolean notSkipping;

        SkipWhileObserver(Observer<? super T> actual, Predicate<? super T> predicate) {
            this.actual = actual;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.notSkipping) {
                this.actual.onNext(t);
            } else {
                boolean b;
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.s.dispose();
                    this.actual.onError(e);
                    return;
                }
                if (!b) {
                    this.notSkipping = true;
                    this.actual.onNext(t);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }
    }
}

