/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.ArrayCompositeDisposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import nakadi.shadow.io.reactivex.observers.SerializedObserver;

public final class ObservableSkipUntil<T, U>
extends AbstractObservableWithUpstream<T, T> {
    final ObservableSource<U> other;

    public ObservableSkipUntil(ObservableSource<T> source, ObservableSource<U> other) {
        super(source);
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super T> child) {
        SerializedObserver<T> serial = new SerializedObserver<T>(child);
        ArrayCompositeDisposable frc = new ArrayCompositeDisposable(2);
        serial.onSubscribe(frc);
        SkipUntilObserver<? super T> sus = new SkipUntilObserver<T>(serial, frc);
        this.other.subscribe(new SkipUntil(frc, sus, serial));
        this.source.subscribe(sus);
    }

    final class SkipUntil
    implements Observer<U> {
        private final ArrayCompositeDisposable frc;
        private final SkipUntilObserver<T> sus;
        private final SerializedObserver<T> serial;
        Disposable s;

        SkipUntil(ArrayCompositeDisposable frc, SkipUntilObserver<T> sus, SerializedObserver<T> serial) {
            this.frc = frc;
            this.sus = sus;
            this.serial = serial;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.frc.setResource(1, s);
            }
        }

        @Override
        public void onNext(U t) {
            this.s.dispose();
            this.sus.notSkipping = true;
        }

        @Override
        public void onError(Throwable t) {
            this.frc.dispose();
            this.serial.onError(t);
        }

        @Override
        public void onComplete() {
            this.sus.notSkipping = true;
        }
    }

    static final class SkipUntilObserver<T>
    implements Observer<T> {
        final Observer<? super T> actual;
        final ArrayCompositeDisposable frc;
        Disposable s;
        volatile boolean notSkipping;
        boolean notSkippingLocal;

        SkipUntilObserver(Observer<? super T> actual, ArrayCompositeDisposable frc) {
            this.actual = actual;
            this.frc = frc;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.frc.setResource(0, s);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.notSkippingLocal) {
                this.actual.onNext(t);
            } else if (this.notSkipping) {
                this.notSkippingLocal = true;
                this.actual.onNext(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.frc.dispose();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.frc.dispose();
            this.actual.onComplete();
        }
    }
}

