/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.Callable;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.BiFunction;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableScanSeed<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final BiFunction<R, ? super T, R> accumulator;
    final Callable<R> seedSupplier;

    public ObservableScanSeed(ObservableSource<T> source, Callable<R> seedSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.accumulator = accumulator;
        this.seedSupplier = seedSupplier;
    }

    @Override
    public void subscribeActual(Observer<? super R> t) {
        R r;
        try {
            r = ObjectHelper.requireNonNull(this.seedSupplier.call(), "The seed supplied is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t);
            return;
        }
        this.source.subscribe(new ScanSeedObserver<T, R>(t, this.accumulator, r));
    }

    static final class ScanSeedObserver<T, R>
    implements Observer<T>,
    Disposable {
        final Observer<? super R> actual;
        final BiFunction<R, ? super T, R> accumulator;
        R value;
        Disposable s;
        boolean done;

        ScanSeedObserver(Observer<? super R> actual, BiFunction<R, ? super T, R> accumulator, R value) {
            this.actual = actual;
            this.accumulator = accumulator;
            this.value = value;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                this.actual.onNext(this.value);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            R u;
            if (this.done) {
                return;
            }
            R v = this.value;
            try {
                u = ObjectHelper.requireNonNull(this.accumulator.apply(v, t), "The accumulator returned a null value");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.dispose();
                this.onError(e);
                return;
            }
            this.value = u;
            this.actual.onNext(u);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }
    }
}

