/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Function;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import nakadi.shadow.io.reactivex.internal.util.AtomicThrowable;
import nakadi.shadow.io.reactivex.internal.util.HalfSerializer;
import nakadi.shadow.io.reactivex.subjects.PublishSubject;
import nakadi.shadow.io.reactivex.subjects.Subject;

public final class ObservableRepeatWhen<T>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super Observable<Object>, ? extends ObservableSource<?>> handler;

    public ObservableRepeatWhen(ObservableSource<T> source, Function<? super Observable<Object>, ? extends ObservableSource<?>> handler) {
        super(source);
        this.handler = handler;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        ObservableSource<?> other;
        Subject<Object> signaller = PublishSubject.create().toSerialized();
        try {
            other = ObjectHelper.requireNonNull(this.handler.apply(signaller), "The handler returned a null ObservableSource");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        RepeatWhenObserver<T> parent = new RepeatWhenObserver<T>(observer, signaller, this.source);
        observer.onSubscribe(parent);
        other.subscribe(parent.inner);
        parent.subscribeNext();
    }

    static final class RepeatWhenObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 802743776666017014L;
        final Observer<? super T> actual;
        final AtomicInteger wip;
        final AtomicThrowable error;
        final Subject<Object> signaller;
        final InnerRepeatObserver inner;
        final AtomicReference<Disposable> d;
        final ObservableSource<T> source;
        volatile boolean active;

        RepeatWhenObserver(Observer<? super T> actual, Subject<Object> signaller, ObservableSource<T> source) {
            this.actual = actual;
            this.signaller = signaller;
            this.source = source;
            this.wip = new AtomicInteger();
            this.error = new AtomicThrowable();
            this.inner = new InnerRepeatObserver();
            this.d = new AtomicReference();
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.replace(this.d, d);
        }

        @Override
        public void onNext(T t) {
            HalfSerializer.onNext(this.actual, t, (AtomicInteger)this, this.error);
        }

        @Override
        public void onError(Throwable e) {
            DisposableHelper.dispose(this.inner);
            HalfSerializer.onError(this.actual, e, (AtomicInteger)this, this.error);
        }

        @Override
        public void onComplete() {
            this.active = false;
            this.signaller.onNext(0);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.d.get());
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.d);
            DisposableHelper.dispose(this.inner);
        }

        void innerNext() {
            this.subscribeNext();
        }

        void innerError(Throwable ex) {
            DisposableHelper.dispose(this.d);
            HalfSerializer.onError(this.actual, ex, (AtomicInteger)this, this.error);
        }

        void innerComplete() {
            DisposableHelper.dispose(this.d);
            HalfSerializer.onComplete(this.actual, (AtomicInteger)this, this.error);
        }

        void subscribeNext() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (this.isDisposed()) {
                        return;
                    }
                    if (this.active) continue;
                    this.active = true;
                    this.source.subscribe(this);
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        final class InnerRepeatObserver
        extends AtomicReference<Disposable>
        implements Observer<Object> {
            private static final long serialVersionUID = 3254781284376480842L;

            InnerRepeatObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onNext(Object t) {
                RepeatWhenObserver.this.innerNext();
            }

            @Override
            public void onError(Throwable e) {
                RepeatWhenObserver.this.innerError(e);
            }

            @Override
            public void onComplete() {
                RepeatWhenObserver.this.innerComplete();
            }
        }
    }
}

