/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.atomic.AtomicInteger;
import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.BooleanSupplier;
import nakadi.shadow.io.reactivex.internal.disposables.SequentialDisposable;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableRepeatUntil<T>
extends AbstractObservableWithUpstream<T, T> {
    final BooleanSupplier until;

    public ObservableRepeatUntil(Observable<T> source, BooleanSupplier until) {
        super(source);
        this.until = until;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        SequentialDisposable sd = new SequentialDisposable();
        s.onSubscribe(sd);
        RepeatUntilObserver<T> rs = new RepeatUntilObserver<T>(s, this.until, sd, this.source);
        rs.subscribeNext();
    }

    static final class RepeatUntilObserver<T>
    extends AtomicInteger
    implements Observer<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Observer<? super T> actual;
        final SequentialDisposable sd;
        final ObservableSource<? extends T> source;
        final BooleanSupplier stop;

        RepeatUntilObserver(Observer<? super T> actual, BooleanSupplier until, SequentialDisposable sd, ObservableSource<? extends T> source) {
            this.actual = actual;
            this.sd = sd;
            this.source = source;
            this.stop = until;
        }

        @Override
        public void onSubscribe(Disposable s) {
            this.sd.replace(s);
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            boolean b;
            try {
                b = this.stop.getAsBoolean();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                return;
            }
            if (b) {
                this.actual.onComplete();
            } else {
                this.subscribeNext();
            }
        }

        void subscribeNext() {
            block1: {
                if (this.getAndIncrement() != 0) break block1;
                int missed = 1;
                do {
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

