/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.annotations.Nullable;
import nakadi.shadow.io.reactivex.internal.observers.BasicIntQueueDisposable;

public final class ObservableRange
extends Observable<Integer> {
    private final int start;
    private final long end;

    public ObservableRange(int start, int count) {
        this.start = start;
        this.end = (long)start + (long)count;
    }

    @Override
    protected void subscribeActual(Observer<? super Integer> o) {
        RangeDisposable parent = new RangeDisposable(o, this.start, this.end);
        o.onSubscribe(parent);
        parent.run();
    }

    static final class RangeDisposable
    extends BasicIntQueueDisposable<Integer> {
        private static final long serialVersionUID = 396518478098735504L;
        final Observer<? super Integer> actual;
        final long end;
        long index;
        boolean fused;

        RangeDisposable(Observer<? super Integer> actual, long start, long end) {
            this.actual = actual;
            this.index = start;
            this.end = end;
        }

        void run() {
            if (this.fused) {
                return;
            }
            Observer<? super Integer> actual = this.actual;
            long e = this.end;
            for (long i = this.index; i != e && this.get() == 0; ++i) {
                actual.onNext((Integer)((int)i));
            }
            if (this.get() == 0) {
                this.lazySet(1);
                actual.onComplete();
            }
        }

        @Override
        @Nullable
        public Integer poll() throws Exception {
            long i = this.index;
            if (i != this.end) {
                this.index = i + 1L;
                return (int)i;
            }
            this.lazySet(1);
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.index == this.end;
        }

        @Override
        public void clear() {
            this.index = this.end;
            this.lazySet(1);
        }

        @Override
        public void dispose() {
            this.set(1);
        }

        @Override
        public boolean isDisposed() {
            return this.get() != 0;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.fused = true;
                return 1;
            }
            return 0;
        }
    }
}

