/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import nakadi.shadow.io.reactivex.Notification;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableMaterialize<T>
extends AbstractObservableWithUpstream<T, Notification<T>> {
    public ObservableMaterialize(ObservableSource<T> source) {
        super(source);
    }

    @Override
    public void subscribeActual(Observer<? super Notification<T>> t) {
        this.source.subscribe(new MaterializeObserver(t));
    }

    static final class MaterializeObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super Notification<T>> actual;
        Disposable s;

        MaterializeObserver(Observer<? super Notification<T>> actual) {
            this.actual = actual;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(Notification.createOnNext(t));
        }

        @Override
        public void onError(Throwable t) {
            Notification v = Notification.createOnError(t);
            this.actual.onNext(v);
            this.actual.onComplete();
        }

        @Override
        public void onComplete() {
            Notification v = Notification.createOnComplete();
            this.actual.onNext(v);
            this.actual.onComplete();
        }
    }
}

