/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.annotations.Nullable;
import nakadi.shadow.io.reactivex.functions.Function;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.observers.BasicFuseableObserver;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableMap<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Function<? super T, ? extends U> function;

    public ObservableMap(ObservableSource<T> source, Function<? super T, ? extends U> function) {
        super(source);
        this.function = function;
    }

    @Override
    public void subscribeActual(Observer<? super U> t) {
        this.source.subscribe(new MapObserver<T, U>(t, this.function));
    }

    static final class MapObserver<T, U>
    extends BasicFuseableObserver<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapObserver(Observer<? super U> actual, Function<? super T, ? extends U> mapper) {
            super(actual);
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t) {
            U v;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(null);
                return;
            }
            try {
                v = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.actual.onNext(v);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public U poll() throws Exception {
            Object t = this.qs.poll();
            return t != null ? (U)ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.") : null;
        }
    }
}

