/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.Scheduler;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;

public final class ObservableIntervalRange
extends Observable<Long> {
    final Scheduler scheduler;
    final long start;
    final long end;
    final long initialDelay;
    final long period;
    final TimeUnit unit;

    public ObservableIntervalRange(long start, long end, long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
        this.start = start;
        this.end = end;
    }

    @Override
    public void subscribeActual(Observer<? super Long> s) {
        IntervalRangeObserver is = new IntervalRangeObserver(s, this.start, this.end);
        s.onSubscribe(is);
        Disposable d = this.scheduler.schedulePeriodicallyDirect(is, this.initialDelay, this.period, this.unit);
        is.setResource(d);
    }

    static final class IntervalRangeObserver
    extends AtomicReference<Disposable>
    implements Disposable,
    Runnable {
        private static final long serialVersionUID = 1891866368734007884L;
        final Observer<? super Long> actual;
        final long end;
        long count;

        IntervalRangeObserver(Observer<? super Long> actual, long start, long end) {
            this.actual = actual;
            this.count = start;
            this.end = end;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == DisposableHelper.DISPOSED;
        }

        @Override
        public void run() {
            if (!this.isDisposed()) {
                long c = this.count;
                this.actual.onNext((Long)c);
                if (c == this.end) {
                    DisposableHelper.dispose(this);
                    this.actual.onComplete();
                    return;
                }
                this.count = c + 1L;
            }
        }

        public void setResource(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }
    }
}

