/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.Callable;
import nakadi.shadow.io.reactivex.Emitter;
import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.BiFunction;
import nakadi.shadow.io.reactivex.functions.Consumer;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableGenerate<T, S>
extends Observable<T> {
    final Callable<S> stateSupplier;
    final BiFunction<S, Emitter<T>, S> generator;
    final Consumer<? super S> disposeState;

    public ObservableGenerate(Callable<S> stateSupplier, BiFunction<S, Emitter<T>, S> generator, Consumer<? super S> disposeState) {
        this.stateSupplier = stateSupplier;
        this.generator = generator;
        this.disposeState = disposeState;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        S state;
        try {
            state = this.stateSupplier.call();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, s);
            return;
        }
        GeneratorDisposable<T, S> gd = new GeneratorDisposable<T, S>(s, this.generator, this.disposeState, state);
        s.onSubscribe(gd);
        gd.run();
    }

    static final class GeneratorDisposable<T, S>
    implements Emitter<T>,
    Disposable {
        final Observer<? super T> actual;
        final BiFunction<S, ? super Emitter<T>, S> generator;
        final Consumer<? super S> disposeState;
        S state;
        volatile boolean cancelled;
        boolean terminate;
        boolean hasNext;

        GeneratorDisposable(Observer<? super T> actual, BiFunction<S, ? super Emitter<T>, S> generator, Consumer<? super S> disposeState, S initialState) {
            this.actual = actual;
            this.generator = generator;
            this.disposeState = disposeState;
            this.state = initialState;
        }

        public void run() {
            S s = this.state;
            if (this.cancelled) {
                this.state = null;
                this.dispose(s);
                return;
            }
            BiFunction<S, Emitter<T>, S> f = this.generator;
            do {
                if (this.cancelled) {
                    this.state = null;
                    this.dispose(s);
                    return;
                }
                this.hasNext = false;
                try {
                    s = f.apply(s, this);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.state = null;
                    this.cancelled = true;
                    this.onError(ex);
                    this.dispose(s);
                    return;
                }
            } while (!this.terminate);
            this.cancelled = true;
            this.state = null;
            this.dispose(s);
        }

        private void dispose(S s) {
            try {
                this.disposeState.accept(s);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }

        @Override
        public void dispose() {
            this.cancelled = true;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void onNext(T t) {
            if (!this.terminate) {
                if (this.hasNext) {
                    this.onError(new IllegalStateException("onNext already called in this generate turn"));
                } else if (t == null) {
                    this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
                } else {
                    this.hasNext = true;
                    this.actual.onNext(t);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.terminate) {
                RxJavaPlugins.onError(t);
            } else {
                if (t == null) {
                    t = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
                }
                this.terminate = true;
                this.actual.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (!this.terminate) {
                this.terminate = true;
                this.actual.onComplete();
            }
        }
    }
}

