/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.Callable;
import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.observers.DeferredScalarDisposable;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableFromCallable<T>
extends Observable<T>
implements Callable<T> {
    final Callable<? extends T> callable;

    public ObservableFromCallable(Callable<? extends T> callable) {
        this.callable = callable;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        T value;
        DeferredScalarDisposable<T> d = new DeferredScalarDisposable<T>(s);
        s.onSubscribe(d);
        if (d.isDisposed()) {
            return;
        }
        try {
            value = ObjectHelper.requireNonNull(this.callable.call(), "Callable returned null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            if (!d.isDisposed()) {
                s.onError(e);
            } else {
                RxJavaPlugins.onError(e);
            }
            return;
        }
        d.complete(value);
    }

    @Override
    public T call() throws Exception {
        return this.callable.call();
    }
}

