/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.Iterator;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Function;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableFlattenIterable<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super T, ? extends Iterable<? extends R>> mapper;

    public ObservableFlattenIterable(ObservableSource<T> source, Function<? super T, ? extends Iterable<? extends R>> mapper) {
        super(source);
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new FlattenIterableObserver<T, R>(observer, this.mapper));
    }

    static final class FlattenIterableObserver<T, R>
    implements Observer<T>,
    Disposable {
        final Observer<? super R> actual;
        final Function<? super T, ? extends Iterable<? extends R>> mapper;
        Disposable d;

        FlattenIterableObserver(Observer<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            Iterator<R> it;
            if (this.d == DisposableHelper.DISPOSED) {
                return;
            }
            try {
                it = this.mapper.apply(value).iterator();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.d.dispose();
                this.onError(ex);
                return;
            }
            Observer<R> a = this.actual;
            while (true) {
                R v;
                boolean b;
                try {
                    b = it.hasNext();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.d.dispose();
                    this.onError(ex);
                    return;
                }
                if (!b) break;
                try {
                    v = ObjectHelper.requireNonNull(it.next(), "The iterator returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.d.dispose();
                    this.onError(ex);
                    return;
                }
                a.onNext(v);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.d == DisposableHelper.DISPOSED) {
                RxJavaPlugins.onError(e);
                return;
            }
            this.d = DisposableHelper.DISPOSED;
            this.actual.onError(e);
        }

        @Override
        public void onComplete() {
            if (this.d == DisposableHelper.DISPOSED) {
                return;
            }
            this.d = DisposableHelper.DISPOSED;
            this.actual.onComplete();
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void dispose() {
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
        }
    }
}

