/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.NoSuchElementException;
import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.Single;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.fuseable.FuseToObservable;
import nakadi.shadow.io.reactivex.internal.operators.observable.ObservableElementAt;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableElementAtSingle<T>
extends Single<T>
implements FuseToObservable<T> {
    final ObservableSource<T> source;
    final long index;
    final T defaultValue;

    public ObservableElementAtSingle(ObservableSource<T> source, long index, T defaultValue) {
        this.source = source;
        this.index = index;
        this.defaultValue = defaultValue;
    }

    @Override
    public void subscribeActual(SingleObserver<? super T> t) {
        this.source.subscribe(new ElementAtObserver<T>(t, this.index, this.defaultValue));
    }

    @Override
    public Observable<T> fuseToObservable() {
        return RxJavaPlugins.onAssembly(new ObservableElementAt<T>(this.source, this.index, this.defaultValue, true));
    }

    static final class ElementAtObserver<T>
    implements Observer<T>,
    Disposable {
        final SingleObserver<? super T> actual;
        final long index;
        final T defaultValue;
        Disposable s;
        long count;
        boolean done;

        ElementAtObserver(SingleObserver<? super T> actual, long index, T defaultValue) {
            this.actual = actual;
            this.index = index;
            this.defaultValue = defaultValue;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            long c = this.count;
            if (c == this.index) {
                this.done = true;
                this.s.dispose();
                this.actual.onSuccess(t);
                return;
            }
            this.count = c + 1L;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                T v = this.defaultValue;
                if (v != null) {
                    this.actual.onSuccess(v);
                } else {
                    this.actual.onError(new NoSuchElementException());
                }
            }
        }
    }
}

