/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.TimeUnit;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.Scheduler;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import nakadi.shadow.io.reactivex.observers.SerializedObserver;

public final class ObservableDelay<T>
extends AbstractObservableWithUpstream<T, T> {
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean delayError;

    public ObservableDelay(ObservableSource<T> source, long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        super(source);
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        Observer<? super T> s = this.delayError ? t : new SerializedObserver<T>(t);
        Scheduler.Worker w = this.scheduler.createWorker();
        this.source.subscribe(new DelayObserver<T>(s, this.delay, this.unit, w, this.delayError));
    }

    static final class DelayObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> actual;
        final long delay;
        final TimeUnit unit;
        final Scheduler.Worker w;
        final boolean delayError;
        Disposable s;

        DelayObserver(Observer<? super T> actual, long delay, TimeUnit unit, Scheduler.Worker w, boolean delayError) {
            this.actual = actual;
            this.delay = delay;
            this.unit = unit;
            this.w = w;
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            this.w.schedule(new OnNext(t), this.delay, this.unit);
        }

        @Override
        public void onError(Throwable t) {
            this.w.schedule(new OnError(t), this.delayError ? this.delay : 0L, this.unit);
        }

        @Override
        public void onComplete() {
            this.w.schedule(new OnComplete(), this.delay, this.unit);
        }

        @Override
        public void dispose() {
            this.s.dispose();
            this.w.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.w.isDisposed();
        }

        final class OnComplete
        implements Runnable {
            OnComplete() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DelayObserver.this.actual.onComplete();
                }
                finally {
                    DelayObserver.this.w.dispose();
                }
            }
        }

        final class OnError
        implements Runnable {
            private final Throwable throwable;

            OnError(Throwable throwable) {
                this.throwable = throwable;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DelayObserver.this.actual.onError(this.throwable);
                }
                finally {
                    DelayObserver.this.w.dispose();
                }
            }
        }

        final class OnNext
        implements Runnable {
            private final T t;

            OnNext(T t) {
                this.t = t;
            }

            @Override
            public void run() {
                DelayObserver.this.actual.onNext(this.t);
            }
        }
    }
}

