/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.SequentialDisposable;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import nakadi.shadow.io.reactivex.internal.util.LinkedArrayList;
import nakadi.shadow.io.reactivex.internal.util.NotificationLite;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableCache<T>
extends AbstractObservableWithUpstream<T, T> {
    final CacheState<T> state;
    final AtomicBoolean once;

    public static <T> Observable<T> from(Observable<T> source) {
        return ObservableCache.from(source, 16);
    }

    public static <T> Observable<T> from(Observable<T> source, int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        CacheState<T> state = new CacheState<T>(source, capacityHint);
        return RxJavaPlugins.onAssembly(new ObservableCache<T>(source, state));
    }

    private ObservableCache(Observable<T> source, CacheState<T> state) {
        super(source);
        this.state = state;
        this.once = new AtomicBoolean();
    }

    @Override
    protected void subscribeActual(Observer<? super T> t) {
        ReplayDisposable<T> rp = new ReplayDisposable<T>(t, this.state);
        t.onSubscribe(rp);
        this.state.addChild(rp);
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            this.state.connect();
        }
        rp.replay();
    }

    boolean isConnected() {
        return this.state.isConnected;
    }

    boolean hasObservers() {
        return this.state.observers.get().length != 0;
    }

    int cachedEventCount() {
        return this.state.size();
    }

    static final class ReplayDisposable<T>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = 7058506693698832024L;
        final Observer<? super T> child;
        final CacheState<T> state;
        Object[] currentBuffer;
        int currentIndexInBuffer;
        int index;
        volatile boolean cancelled;

        ReplayDisposable(Observer<? super T> child, CacheState<T> state) {
            this.child = child;
            this.state = state;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.removeChild(this);
            }
        }

        public void replay() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Observer<? super T> child = this.child;
            int missed = 1;
            do {
                int j;
                if (this.cancelled) {
                    return;
                }
                int s = this.state.size();
                if (s == 0) continue;
                Object[] b = this.currentBuffer;
                if (b == null) {
                    this.currentBuffer = b = this.state.head();
                }
                int n = b.length - 1;
                int k = this.currentIndexInBuffer;
                for (j = this.index; j < s; ++j) {
                    Object o;
                    if (this.cancelled) {
                        return;
                    }
                    if (k == n) {
                        b = (Object[])b[n];
                        k = 0;
                    }
                    if (NotificationLite.accept(o = b[k], child)) {
                        return;
                    }
                    ++k;
                }
                if (this.cancelled) {
                    return;
                }
                this.index = j;
                this.currentIndexInBuffer = k;
                this.currentBuffer = b;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }

    static final class CacheState<T>
    extends LinkedArrayList
    implements Observer<T> {
        final Observable<? extends T> source;
        final SequentialDisposable connection;
        final AtomicReference<ReplayDisposable<T>[]> observers;
        static final ReplayDisposable[] EMPTY = new ReplayDisposable[0];
        static final ReplayDisposable[] TERMINATED = new ReplayDisposable[0];
        volatile boolean isConnected;
        boolean sourceDone;

        CacheState(Observable<? extends T> source, int capacityHint) {
            super(capacityHint);
            this.source = source;
            this.observers = new AtomicReference<ReplayDisposable[]>(EMPTY);
            this.connection = new SequentialDisposable();
        }

        public boolean addChild(ReplayDisposable<T> p) {
            ReplayDisposable[] b;
            ReplayDisposable<T>[] a;
            do {
                if ((a = this.observers.get()) == TERMINATED) {
                    return false;
                }
                int n = a.length;
                b = new ReplayDisposable[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = p;
            } while (!this.observers.compareAndSet(a, b));
            return true;
        }

        public void removeChild(ReplayDisposable<T> p) {
            ReplayDisposable[] b;
            ReplayDisposable<T>[] a;
            do {
                int n;
                if ((n = (a = this.observers.get()).length) == 0) {
                    return;
                }
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (!a[i].equals(p)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new ReplayDisposable[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.observers.compareAndSet(a, b));
        }

        @Override
        public void onSubscribe(Disposable s) {
            this.connection.update(s);
        }

        public void connect() {
            this.source.subscribe(this);
            this.isConnected = true;
        }

        @Override
        public void onNext(T t) {
            if (!this.sourceDone) {
                Object o = NotificationLite.next(t);
                this.add(o);
                for (ReplayDisposable<T> rp : this.observers.get()) {
                    rp.replay();
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            if (!this.sourceDone) {
                this.sourceDone = true;
                Object o = NotificationLite.error(e);
                this.add(o);
                this.connection.dispose();
                for (ReplayDisposable rp : this.observers.getAndSet(TERMINATED)) {
                    rp.replay();
                }
            }
        }

        @Override
        public void onComplete() {
            if (!this.sourceDone) {
                this.sourceDone = true;
                Object o = NotificationLite.complete();
                this.add(o);
                this.connection.dispose();
                for (ReplayDisposable rp : this.observers.getAndSet(TERMINATED)) {
                    rp.replay();
                }
            }
        }
    }
}

