/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.Collection;
import java.util.concurrent.Callable;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.observers.QueueDrainObserver;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import nakadi.shadow.io.reactivex.internal.queue.MpscLinkedQueue;
import nakadi.shadow.io.reactivex.internal.util.QueueDrainHelper;
import nakadi.shadow.io.reactivex.observers.DisposableObserver;
import nakadi.shadow.io.reactivex.observers.SerializedObserver;

public final class ObservableBufferExactBoundary<T, U extends Collection<? super T>, B>
extends AbstractObservableWithUpstream<T, U> {
    final ObservableSource<B> boundary;
    final Callable<U> bufferSupplier;

    public ObservableBufferExactBoundary(ObservableSource<T> source, ObservableSource<B> boundary, Callable<U> bufferSupplier) {
        super(source);
        this.boundary = boundary;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t) {
        this.source.subscribe(new BufferExactBoundaryObserver(new SerializedObserver<U>(t), this.bufferSupplier, this.boundary));
    }

    static final class BufferBoundaryObserver<T, U extends Collection<? super T>, B>
    extends DisposableObserver<B> {
        final BufferExactBoundaryObserver<T, U, B> parent;

        BufferBoundaryObserver(BufferExactBoundaryObserver<T, U, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t) {
            this.parent.next();
        }

        @Override
        public void onError(Throwable t) {
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            this.parent.onComplete();
        }
    }

    static final class BufferExactBoundaryObserver<T, U extends Collection<? super T>, B>
    extends QueueDrainObserver<T, U, U>
    implements Observer<T>,
    Disposable {
        final Callable<U> bufferSupplier;
        final ObservableSource<B> boundary;
        Disposable s;
        Disposable other;
        U buffer;

        BufferExactBoundaryObserver(Observer<? super U> actual, Callable<U> bufferSupplier, ObservableSource<B> boundary) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundary = boundary;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                BufferBoundaryObserver bs;
                Collection b;
                this.s = s;
                try {
                    b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.cancelled = true;
                    s.dispose();
                    EmptyDisposable.error(e, this.actual);
                    return;
                }
                this.buffer = b;
                this.other = bs = new BufferBoundaryObserver(this);
                this.actual.onSubscribe(this);
                if (!this.cancelled) {
                    this.boundary.subscribe(bs);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            BufferExactBoundaryObserver bufferExactBoundaryObserver = this;
            synchronized (bufferExactBoundaryObserver) {
                U b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.dispose();
            this.actual.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b;
            BufferExactBoundaryObserver bufferExactBoundaryObserver = this;
            synchronized (bufferExactBoundaryObserver) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainLoop(this.queue, this.actual, false, this, this);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.other.dispose();
                this.s.dispose();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            U b;
            Collection next;
            try {
                next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.dispose();
                this.actual.onError(e);
                return;
            }
            BufferExactBoundaryObserver bufferExactBoundaryObserver = this;
            synchronized (bufferExactBoundaryObserver) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathEmit(b, false, this);
        }

        @Override
        public void accept(Observer<? super U> a, U v) {
            this.actual.onNext(v);
        }
    }
}

