/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.functions.Action;
import nakadi.shadow.io.reactivex.functions.Consumer;
import nakadi.shadow.io.reactivex.internal.functions.Functions;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.observers.BlockingObserver;
import nakadi.shadow.io.reactivex.internal.observers.LambdaObserver;
import nakadi.shadow.io.reactivex.internal.util.BlockingHelper;
import nakadi.shadow.io.reactivex.internal.util.BlockingIgnoringReceiver;
import nakadi.shadow.io.reactivex.internal.util.ExceptionHelper;
import nakadi.shadow.io.reactivex.internal.util.NotificationLite;

public final class ObservableBlockingSubscribe {
    private ObservableBlockingSubscribe() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> void subscribe(ObservableSource<? extends T> o, Observer<? super T> observer) {
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BlockingObserver bs = new BlockingObserver((Queue<Object>)queue);
        observer.onSubscribe(bs);
        o.subscribe(bs);
        while (!bs.isDisposed()) {
            Object v = queue.poll();
            if (v == null) {
                try {
                    v = queue.take();
                }
                catch (InterruptedException ex) {
                    bs.dispose();
                    observer.onError(ex);
                    return;
                }
            }
            if (!bs.isDisposed() && o != BlockingObserver.TERMINATED && !NotificationLite.acceptFull(v, observer)) continue;
            break;
        }
    }

    public static <T> void subscribe(ObservableSource<? extends T> o) {
        BlockingIgnoringReceiver callback = new BlockingIgnoringReceiver();
        LambdaObserver ls = new LambdaObserver(Functions.emptyConsumer(), callback, callback, Functions.emptyConsumer());
        o.subscribe(ls);
        BlockingHelper.awaitForComplete(callback, ls);
        Throwable e = callback.error;
        if (e != null) {
            throw ExceptionHelper.wrapOrThrow(e);
        }
    }

    public static <T> void subscribe(ObservableSource<? extends T> o, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        ObjectHelper.requireNonNull(onNext, "onNext is null");
        ObjectHelper.requireNonNull(onError, "onError is null");
        ObjectHelper.requireNonNull(onComplete, "onComplete is null");
        ObservableBlockingSubscribe.subscribe(o, new LambdaObserver<T>(onNext, onError, onComplete, Functions.emptyConsumer()));
    }
}

