/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Predicate;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableAny<T>
extends AbstractObservableWithUpstream<T, Boolean> {
    final Predicate<? super T> predicate;

    public ObservableAny(ObservableSource<T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(Observer<? super Boolean> t) {
        this.source.subscribe(new AnyObserver<T>(t, this.predicate));
    }

    static final class AnyObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super Boolean> actual;
        final Predicate<? super T> predicate;
        Disposable s;
        boolean done;

        AnyObserver(Observer<? super Boolean> actual, Predicate<? super T> predicate) {
            this.actual = actual;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            boolean b;
            if (this.done) {
                return;
            }
            try {
                b = this.predicate.test(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.dispose();
                this.onError(e);
                return;
            }
            if (b) {
                this.done = true;
                this.s.dispose();
                this.actual.onNext((Boolean)true);
                this.actual.onComplete();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.actual.onNext((Boolean)false);
                this.actual.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }
    }
}

