/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.observable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import nakadi.shadow.io.reactivex.Notification;
import nakadi.shadow.io.reactivex.ObservableSource;
import nakadi.shadow.io.reactivex.internal.operators.observable.ObservableMaterialize;
import nakadi.shadow.io.reactivex.internal.util.BlockingHelper;
import nakadi.shadow.io.reactivex.internal.util.ExceptionHelper;
import nakadi.shadow.io.reactivex.observers.DisposableObserver;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class BlockingObservableNext<T>
implements Iterable<T> {
    final ObservableSource<T> source;

    public BlockingObservableNext(ObservableSource<T> source) {
        this.source = source;
    }

    @Override
    public Iterator<T> iterator() {
        NextObserver nextObserver = new NextObserver();
        return new NextIterator<T>(this.source, nextObserver);
    }

    static final class NextObserver<T>
    extends DisposableObserver<Notification<T>> {
        private final BlockingQueue<Notification<T>> buf = new ArrayBlockingQueue<Notification<T>>(1);
        final AtomicInteger waiting = new AtomicInteger();

        NextObserver() {
        }

        @Override
        public void onComplete() {
        }

        @Override
        public void onError(Throwable e) {
            RxJavaPlugins.onError(e);
        }

        @Override
        public void onNext(Notification<T> args) {
            if (this.waiting.getAndSet(0) == 1 || !args.isOnNext()) {
                Notification toOffer = args;
                while (!this.buf.offer(toOffer)) {
                    Notification concurrentItem = (Notification)this.buf.poll();
                    if (concurrentItem == null || concurrentItem.isOnNext()) continue;
                    toOffer = concurrentItem;
                }
            }
        }

        public Notification<T> takeNext() throws InterruptedException {
            this.setWaiting();
            BlockingHelper.verifyNonBlocking();
            return this.buf.take();
        }

        void setWaiting() {
            this.waiting.set(1);
        }
    }

    static final class NextIterator<T>
    implements Iterator<T> {
        private final NextObserver<T> observer;
        private final ObservableSource<T> items;
        private T next;
        private boolean hasNext = true;
        private boolean isNextConsumed = true;
        private Throwable error;
        private boolean started;

        NextIterator(ObservableSource<T> items, NextObserver<T> observer) {
            this.items = items;
            this.observer = observer;
        }

        @Override
        public boolean hasNext() {
            if (this.error != null) {
                throw ExceptionHelper.wrapOrThrow(this.error);
            }
            if (!this.hasNext) {
                return false;
            }
            return !this.isNextConsumed || this.moveToNext();
        }

        private boolean moveToNext() {
            Notification<T> nextNotification;
            if (!this.started) {
                this.started = true;
                this.observer.setWaiting();
                new ObservableMaterialize<T>(this.items).subscribe(this.observer);
            }
            try {
                nextNotification = this.observer.takeNext();
            }
            catch (InterruptedException e) {
                this.observer.dispose();
                this.error = e;
                throw ExceptionHelper.wrapOrThrow(e);
            }
            if (nextNotification.isOnNext()) {
                this.isNextConsumed = false;
                this.next = nextNotification.getValue();
                return true;
            }
            this.hasNext = false;
            if (nextNotification.isOnComplete()) {
                return false;
            }
            this.error = nextNotification.getError();
            throw ExceptionHelper.wrapOrThrow(this.error);
        }

        @Override
        public T next() {
            if (this.error != null) {
                throw ExceptionHelper.wrapOrThrow(this.error);
            }
            if (this.hasNext()) {
                this.isNextConsumed = true;
                return this.next;
            }
            throw new NoSuchElementException("No more elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read only iterator");
        }
    }
}

