/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.maybe;

import java.util.Arrays;
import nakadi.shadow.io.reactivex.Maybe;
import nakadi.shadow.io.reactivex.MaybeObserver;
import nakadi.shadow.io.reactivex.MaybeSource;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Function;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.internal.operators.maybe.MaybeMap;
import nakadi.shadow.io.reactivex.internal.operators.maybe.MaybeZipArray;

public final class MaybeZipIterable<T, R>
extends Maybe<R> {
    final Iterable<? extends MaybeSource<? extends T>> sources;
    final Function<? super Object[], ? extends R> zipper;

    public MaybeZipIterable(Iterable<? extends MaybeSource<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void subscribeActual(MaybeObserver<? super R> observer) {
        void var5_8;
        MaybeSource[] a = new MaybeSource[8];
        int n = 0;
        try {
            for (MaybeSource<? extends T> maybeSource : this.sources) {
                if (maybeSource == null) {
                    EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), observer);
                    return;
                }
                if (n == a.length) {
                    a = Arrays.copyOf(a, n + (n >> 2));
                }
                a[n++] = maybeSource;
            }
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        if (n == 0) {
            EmptyDisposable.complete(observer);
            return;
        }
        if (n == 1) {
            a[0].subscribe(new MaybeMap.MapMaybeObserver(observer, new SingletonArrayFunc()));
            return;
        }
        MaybeZipArray.ZipCoordinator parent = new MaybeZipArray.ZipCoordinator(observer, n, this.zipper);
        observer.onSubscribe(parent);
        boolean bl = false;
        while (var5_8 < n) {
            if (parent.isDisposed()) {
                return;
            }
            a[var5_8].subscribe(parent.observers[var5_8]);
            ++var5_8;
        }
    }

    final class SingletonArrayFunc
    implements Function<T, R> {
        SingletonArrayFunc() {
        }

        @Override
        public R apply(T t) throws Exception {
            return MaybeZipIterable.this.zipper.apply((Object[])new Object[]{t});
        }
    }
}

