/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.maybe;

import nakadi.shadow.io.reactivex.MaybeObserver;
import nakadi.shadow.io.reactivex.MaybeSource;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.CompositeException;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Action;
import nakadi.shadow.io.reactivex.functions.Consumer;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.internal.operators.maybe.AbstractMaybeWithUpstream;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class MaybePeek<T>
extends AbstractMaybeWithUpstream<T, T> {
    final Consumer<? super Disposable> onSubscribeCall;
    final Consumer<? super T> onSuccessCall;
    final Consumer<? super Throwable> onErrorCall;
    final Action onCompleteCall;
    final Action onAfterTerminate;
    final Action onDisposeCall;

    public MaybePeek(MaybeSource<T> source, Consumer<? super Disposable> onSubscribeCall, Consumer<? super T> onSuccessCall, Consumer<? super Throwable> onErrorCall, Action onCompleteCall, Action onAfterTerminate, Action onDispose) {
        super(source);
        this.onSubscribeCall = onSubscribeCall;
        this.onSuccessCall = onSuccessCall;
        this.onErrorCall = onErrorCall;
        this.onCompleteCall = onCompleteCall;
        this.onAfterTerminate = onAfterTerminate;
        this.onDisposeCall = onDispose;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new MaybePeekObserver<T>(observer, this));
    }

    static final class MaybePeekObserver<T>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super T> actual;
        final MaybePeek<T> parent;
        Disposable d;

        MaybePeekObserver(MaybeObserver<? super T> actual, MaybePeek<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        @Override
        public void dispose() {
            try {
                this.parent.onDisposeCall.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                try {
                    this.parent.onSubscribeCall.accept(d);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    d.dispose();
                    this.d = DisposableHelper.DISPOSED;
                    EmptyDisposable.error(ex, this.actual);
                    return;
                }
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            if (this.d == DisposableHelper.DISPOSED) {
                return;
            }
            try {
                this.parent.onSuccessCall.accept(value);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.onErrorInner(ex);
                return;
            }
            this.d = DisposableHelper.DISPOSED;
            this.actual.onSuccess(value);
            this.onAfterTerminate();
        }

        @Override
        public void onError(Throwable e) {
            if (this.d == DisposableHelper.DISPOSED) {
                RxJavaPlugins.onError(e);
                return;
            }
            this.onErrorInner(e);
        }

        void onErrorInner(Throwable e) {
            try {
                this.parent.onErrorCall.accept(e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                e = new CompositeException(e, ex);
            }
            this.d = DisposableHelper.DISPOSED;
            this.actual.onError(e);
            this.onAfterTerminate();
        }

        @Override
        public void onComplete() {
            if (this.d == DisposableHelper.DISPOSED) {
                return;
            }
            try {
                this.parent.onCompleteCall.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.onErrorInner(ex);
                return;
            }
            this.d = DisposableHelper.DISPOSED;
            this.actual.onComplete();
            this.onAfterTerminate();
        }

        void onAfterTerminate() {
            try {
                this.parent.onAfterTerminate.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }
    }
}

