/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.maybe;

import nakadi.shadow.io.reactivex.Maybe;
import nakadi.shadow.io.reactivex.MaybeObserver;
import nakadi.shadow.io.reactivex.MaybeSource;
import nakadi.shadow.io.reactivex.Single;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.fuseable.FuseToMaybe;
import nakadi.shadow.io.reactivex.internal.fuseable.HasUpstreamMaybeSource;
import nakadi.shadow.io.reactivex.internal.operators.maybe.MaybeIsEmpty;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class MaybeIsEmptySingle<T>
extends Single<Boolean>
implements HasUpstreamMaybeSource<T>,
FuseToMaybe<Boolean> {
    final MaybeSource<T> source;

    public MaybeIsEmptySingle(MaybeSource<T> source) {
        this.source = source;
    }

    @Override
    public MaybeSource<T> source() {
        return this.source;
    }

    @Override
    public Maybe<Boolean> fuseToMaybe() {
        return RxJavaPlugins.onAssembly(new MaybeIsEmpty<T>(this.source));
    }

    @Override
    protected void subscribeActual(SingleObserver<? super Boolean> observer) {
        this.source.subscribe(new IsEmptyMaybeObserver(observer));
    }

    static final class IsEmptyMaybeObserver<T>
    implements MaybeObserver<T>,
    Disposable {
        final SingleObserver<? super Boolean> actual;
        Disposable d;

        IsEmptyMaybeObserver(SingleObserver<? super Boolean> actual) {
            this.actual = actual;
        }

        @Override
        public void dispose() {
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.d = DisposableHelper.DISPOSED;
            this.actual.onSuccess((Boolean)false);
        }

        @Override
        public void onError(Throwable e) {
            this.d = DisposableHelper.DISPOSED;
            this.actual.onError(e);
        }

        @Override
        public void onComplete() {
            this.d = DisposableHelper.DISPOSED;
            this.actual.onSuccess((Boolean)true);
        }
    }
}

