/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.maybe;

import nakadi.shadow.io.reactivex.Maybe;
import nakadi.shadow.io.reactivex.MaybeObserver;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.SingleSource;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.fuseable.HasUpstreamSingleSource;

public final class MaybeFromSingle<T>
extends Maybe<T>
implements HasUpstreamSingleSource<T> {
    final SingleSource<T> source;

    public MaybeFromSingle(SingleSource<T> source) {
        this.source = source;
    }

    @Override
    public SingleSource<T> source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new FromSingleObserver<T>(observer));
    }

    static final class FromSingleObserver<T>
    implements SingleObserver<T>,
    Disposable {
        final MaybeObserver<? super T> actual;
        Disposable d;

        FromSingleObserver(MaybeObserver<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void dispose() {
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.d = DisposableHelper.DISPOSED;
            this.actual.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            this.d = DisposableHelper.DISPOSED;
            this.actual.onError(e);
        }
    }
}

