/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.maybe;

import java.util.concurrent.Callable;
import nakadi.shadow.io.reactivex.Maybe;
import nakadi.shadow.io.reactivex.MaybeObserver;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.disposables.Disposables;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class MaybeFromCallable<T>
extends Maybe<T>
implements Callable<T> {
    final Callable<? extends T> callable;

    public MaybeFromCallable(Callable<? extends T> callable) {
        this.callable = callable;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        Disposable d = Disposables.empty();
        observer.onSubscribe(d);
        if (!d.isDisposed()) {
            T v;
            try {
                v = this.callable.call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                if (!d.isDisposed()) {
                    observer.onError(ex);
                } else {
                    RxJavaPlugins.onError(ex);
                }
                return;
            }
            if (!d.isDisposed()) {
                if (v == null) {
                    observer.onComplete();
                } else {
                    observer.onSuccess(v);
                }
            }
        }
    }

    @Override
    public T call() throws Exception {
        return this.callable.call();
    }
}

