/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.maybe;

import nakadi.shadow.io.reactivex.Maybe;
import nakadi.shadow.io.reactivex.MaybeObserver;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.SingleSource;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Predicate;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;

public final class MaybeFilterSingle<T>
extends Maybe<T> {
    final SingleSource<T> source;
    final Predicate<? super T> predicate;

    public MaybeFilterSingle(SingleSource<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new FilterMaybeObserver<T>(observer, this.predicate));
    }

    static final class FilterMaybeObserver<T>
    implements SingleObserver<T>,
    Disposable {
        final MaybeObserver<? super T> actual;
        final Predicate<? super T> predicate;
        Disposable d;

        FilterMaybeObserver(MaybeObserver<? super T> actual, Predicate<? super T> predicate) {
            this.actual = actual;
            this.predicate = predicate;
        }

        @Override
        public void dispose() {
            Disposable d = this.d;
            this.d = DisposableHelper.DISPOSED;
            d.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            boolean b;
            try {
                b = this.predicate.test(value);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.actual.onError(ex);
                return;
            }
            if (b) {
                this.actual.onSuccess(value);
            } else {
                this.actual.onComplete();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.actual.onError(e);
        }
    }
}

