/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.maybe;

import nakadi.shadow.io.reactivex.MaybeObserver;
import nakadi.shadow.io.reactivex.MaybeSource;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.CompositeException;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.BiConsumer;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.operators.maybe.AbstractMaybeWithUpstream;

public final class MaybeDoOnEvent<T>
extends AbstractMaybeWithUpstream<T, T> {
    final BiConsumer<? super T, ? super Throwable> onEvent;

    public MaybeDoOnEvent(MaybeSource<T> source, BiConsumer<? super T, ? super Throwable> onEvent) {
        super(source);
        this.onEvent = onEvent;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new DoOnEventMaybeObserver<T>(observer, this.onEvent));
    }

    static final class DoOnEventMaybeObserver<T>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super T> actual;
        final BiConsumer<? super T, ? super Throwable> onEvent;
        Disposable d;

        DoOnEventMaybeObserver(MaybeObserver<? super T> actual, BiConsumer<? super T, ? super Throwable> onEvent) {
            this.actual = actual;
            this.onEvent = onEvent;
        }

        @Override
        public void dispose() {
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.d = DisposableHelper.DISPOSED;
            try {
                this.onEvent.accept(value, null);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.actual.onError(ex);
                return;
            }
            this.actual.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            this.d = DisposableHelper.DISPOSED;
            try {
                this.onEvent.accept(null, e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                e = new CompositeException(e, ex);
            }
            this.actual.onError(e);
        }

        @Override
        public void onComplete() {
            this.d = DisposableHelper.DISPOSED;
            try {
                this.onEvent.accept(null, null);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.actual.onError(ex);
                return;
            }
            this.actual.onComplete();
        }
    }
}

